name = "Health Regeneration"
description = [[Players will regenerate their health when their hunger and sanity levels are above certain levels, as a trade-off they will loose hunger.]]
author = "Holpites"
version = "1.0.2"

forumthread = ""

api_version = 6
priority = -0.1

icon_atlas = "modicon.xml"
icon = "modicon.tex"

dont_starve_compatible = true
reign_of_giants_compatible = true
shipwrecked_compatible = true
dst_compatible = true
client_only_mod = false
all_clients_require_mod = true

configuration_options =
{
    { 
        name = "REQUIRED_HUNGER_PRECENT",
        label = "Required Hunger",
		hover = "Determines the required hunger for health regeneration.",
        options =
        {
            {
                description = "None",
                data = 0
            },
			{
                description = ">25%",
                data = 0.25
            },
            {
                description = ">50%",
                data = 0.50
            },
			{
                description = ">66%",
                data = 0.66
            },			
			{
                description = ">75%",
                data = 0.75
            },
			{
                description = ">85%",
                data = 0.85
            },
        },
        default = 0.66,
    },
    { 
        name = "REQUIRED_SANITY_PERCENT",
        label = "Required Sanity",
		hover = "Determines the required sanity for health regeneration.",
        options =
        {
            {
                description = "None",
                data = 0
            },
			{
                description = ">25%",
                data = 0.25
            },
            {
                description = ">50%",
                data = 0.50
            },
			{
                description = ">66%",
                data = 0.66
            },
			{
                description = ">75%",
                data = 0.75
            },
			{
                description = ">85%",
                data = 0.85
            },
        },
        default = 0.25,
    },	
    {
        name = "REGENERATION_RATE",
        label = "Regeneration Rate",
		hover = "This rate determines the speed of regeneration.",
        options =
        {
            {
                description = "Slow",
                data = 105,
				hover = "0.6 HP/Minute"
            },
            {
                description = "Slower",
                data =60,
				hover = "1 HP/Minute"
            },
            {
                description = "Normal", --~15.5 HP/Day
                data = 32,
				hover = "2 HP/Minute"
            },
            {
                description = "Faster",
                data = 15,
				hover = "4 HP/Minute"
            },
            {
                description = "Fast",
                data = 8,
				hover = "7.5 HP/Minute"
            },
        },
        default = 32,
    },
    {
        name = "HUNGER_DRAIN_RATE",
        label = "Hunger Drain Rate",
		hover = "This rate determines the speed of the hunger drain.",
        options =
        {
            {
                description = "None",
                data = 0,
				hover = "Hunger drain disabled"
            },
            {
                description = "Slow",
                data = 0.8
            },
            {
                description = "Slower",
                data = 1
            },
            {
                description = "Normal",
                data = 1.2
            },
            {
                description = "Faster",
                data = 1.6
            },
            {
                description = "Fast",
                data = 2
            },
        },
        default = 1.2,
    },
    {
        name = "REGEN_WIDGET_ENABLED",
        label = "Widget Enabled",
		hover = "Determines whether the widget should be displayed.",
        options =
        {
            {
                description = "Yes",
                data = true,
				hover = "Widget enabled"
            },
            {
                description = "No",
                data = false,
				hover = "Widget disabled"
            },
        },
        default = true,
    },		
}